package com.elitesland.yst.emdg.common.model.query;

import com.elitescloud.boot.excel.common.param.AbstractExportQueryParam;
import com.elitesland.yst.emdg.common.model.EmdgBizLogActionEnum;
import com.elitesland.yst.emdg.common.model.EmdgBizLogDomainEnum;
import com.elitesland.yst.emdg.common.model.EmdgBizLogOperatorEnum;
import com.elitesland.yst.emdg.common.model.EmdgBizLogTypeEnum;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serial;
import java.time.LocalDateTime;


@Data
@ApiModel(value = "EmdgBizOptLogQueryParam", description = "EMDG业务操作日志查询参数对象-带导出参数")
public class EmdgBizOptLogQueryParam extends AbstractExportQueryParam {

    @Serial
    private static final long serialVersionUID = -5391459432477655797L;

    @ApiModelProperty(value = "TRACE ID")
    private String traceId;

    @ApiModelProperty(value = "业务领域")
    private EmdgBizLogDomainEnum domain;

    @ApiModelProperty(value = "服务名称")
    private String serviceName;

    @ApiModelProperty(value = "日志类型")
    private EmdgBizLogTypeEnum logType;

    @ApiModelProperty(value = "操作类型")
    private EmdgBizLogActionEnum action;

    @ApiModelProperty(value = "业务操作人")
    private String operator;

    @ApiModelProperty(value = "业务操作类型")
    private EmdgBizLogOperatorEnum operatorType;

    @ApiModelProperty(value = "单据ID-Long")
    private Long docId;

    @ApiModelProperty(value = "单据编号")
    private String docNo;

    @ApiModelProperty(value = "单据类型")
    private String docType;

    @ApiModelProperty(value = "日志时间范围-起")
    private LocalDateTime logTimeS;

    @ApiModelProperty(value = "日志时间范围-止")
    private LocalDateTime logTimeE;
}
