package com.elitesland.yst.emdg.common.model;

import com.fasterxml.jackson.annotation.JsonValue;

public enum EmdgBizLogActionEnum {
    CREATE("创建"),
    SIGN("签发"),
    SHIP("发运"),
    UPLOAD("上传"),
    UPDATE("更新"),
    DELETE("删除"),
    QUERY("查询"),
    EXPORT("导出"),
    IMPORT("导入"),
    APPROVE("审批通过"),
    CANCEL("取消"),
    REJECT("审批拒绝"),
    REOPEN("重开"),
    WRITEOFF("核销"),
    RESTORE("订单恢复"),
    CLOSE("关闭"),
    CHANGE("变更"),
    OTHER("其他");

    private final String desc;

    EmdgBizLogActionEnum(String desc) {
        this.desc = desc;
    }

    @JsonValue
    public String getDesc() {
        return desc;
    }
}
