package com.elitesland.yst.emdg.common.provider;


import com.elitescloud.boot.common.param.IdCodeNameParam;
import com.elitesland.yst.emdg.common.CommonApplication;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

@Validated
@FeignClient(name = CommonApplication.NAME,path = CommonApplication.PATH + EmdgSysRoleRpcService.PATH)
public interface EmdgSysRoleRpcService {

    String PATH = "/emdgSysRole";


    /**
     * 根据角色code查询角色信息
     * @param roleCode
     * @return
     */
    @PostMapping("/querySysRoleByRoleCodes")
    List<IdCodeNameParam> querySysRoleByRoleCodes(@RequestBody List<String> roleCodes);
}
