package com.elitesland.yst.emdg.fin.rpc.param.account;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;


/**
 * @author wang.xl
 * @version V1.0
 * @Package com.elitesland.yst.emdg.fin.rpc.param.account
 * @date 2023/4/18 14:06
 */
@Data
public class AccountRpcParam implements Serializable {

    @ApiModelProperty("公司编码")
    private String ouCode;

    @ApiModelProperty("公司id")
    private Long ouId;

    @ApiModelProperty("公司名称")
    private String ouName;

    @ApiModelProperty("公司类型")
    private String ouType;

    @ApiModelProperty("所属区域")
    private String area;

    @ApiModelProperty("账户编码")
    private String accCode;

    @ApiModelProperty("账户名称")
    private String accName;

    @ApiModelProperty("账户名称")
    private String accNameCode;

    @ApiModelProperty("账户类型(ZCCZZH-整车储值账户,PJCZZH-配件储值账户,FJCZZH-附件包储值账户,ZCFLZH-整车返利账户,PJFLZH-配件返利账户)")
    private String accType;

    @ApiModelProperty("账户金额")
    private BigDecimal accAmt;

    @ApiModelProperty("账户占用金额")
    private BigDecimal accOccAmt;

    @ApiModelProperty("账户可用金额")
    private BigDecimal accAvaAmt;

    @ApiModelProperty("区域名称")
    private String areaName;

    // ext
    @ApiModelProperty("客户id")
    private Long dealerId;

    @ApiModelProperty("客户编码")
    private String dealerCode;

    @ApiModelProperty("客户名称")
    private String dealerName;

    @ApiModelProperty("客户序号")
    private String dealerSerialNo;

    @ApiModelProperty("客户简称")
    private String dealerAbbr;

    @ApiModelProperty("开票方名称")
    private String invName;

    @ApiModelProperty("开票方编码")
    private String invCode;

    @ApiModelProperty("开票方简称")
    private String invAbbr;

    @ApiModelProperty("开票方id")
    private Long invId;

    @ApiModelProperty("开票方序号")
    private String invSerialNo;

}
