package com.elitesland.yst.emdg.fin.rpc.dto.account;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;

/**
 * @author wang.xl
 * @version V1.0
 * @Package com.elitesland.yst.emdg.fin.rpc.dto.account
 * @date 2023/3/7 14:34
 */
@Data
public class AccountExtRpcDTO {

    @ApiModelProperty("储值账户可用金额")
    private BigDecimal czAccAvaAmt = BigDecimal.ZERO;

    @ApiModelProperty("返利账户可用金额")
    private BigDecimal flAccAvaAmt = BigDecimal.ZERO;

    @ApiModelProperty("总计返利可用金额")
    private BigDecimal allFlAccAmt = BigDecimal.ZERO;

    @ApiModelProperty("可用金额（储值可用+返利可用）")
    private BigDecimal accAvaAmt = BigDecimal.ZERO;

    @ApiModelProperty("授信金额")
    private BigDecimal creditAmt = BigDecimal.ZERO;

    @ApiModelProperty("订单金额")
    private BigDecimal orderAmt = BigDecimal.ZERO;

    @ApiModelProperty("订单号")
    private String orderNo;

    @ApiModelProperty("客户编码")
    private String dealerCode;

    @ApiModelProperty("是否充值")
    private Boolean reCharge;

    @ApiModelProperty("返利占用金额")
    private BigDecimal flOccAmt = BigDecimal.ZERO;

    @ApiModelProperty("储值占用金额")
    private BigDecimal czOccAmt = BigDecimal.ZERO;

    @ApiModelProperty("返利账户编码")
    private String flAccCode;

    @ApiModelProperty("返利账户名称")
    private String flAccName;

    @ApiModelProperty("储值账户编码")
    private String czAccCode;

    @ApiModelProperty("储值账户名称")
    private String czAccName;

    @ApiModelProperty("是否调整")
    private Boolean adjust;

    @ApiModelProperty("调整金额")
    private BigDecimal adjustAmt = BigDecimal.ZERO;

    private String accName;

    private String accCode;

    private Boolean autoCreditFlag;

}
