package com.elitesland.yst.emdg.inv.dto;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serial;
import java.io.Serializable;
import java.util.List;

/**
 * <p>
 * 功能说明:
 * </p>
 *
 * @Author Darren
 * @Date 2025/02/05
 * @Version 1.0
 * @Content:
 */
@Data
@ApiModel(value = "emdgInvWhRpcDTO ", description = "仓库RPC出参")
public class EmdgInvWhRpcDTO implements Serializable {


    @Serial
    private static final long serialVersionUID = -6587595415105565842L;

    @ApiModelProperty("仓库ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long whId;

    @ApiModelProperty("仓库编码")
    private String whCode;

    @ApiModelProperty("仓库名称")
    private String whName;

    @ApiModelProperty("外部仓库编号")
    private String otherWhCode;

    @ApiModelProperty("销售组织编码")
    private Object desCodeJson;

    @ApiModelProperty("销售组织编码集合")
    private List<String> desCodeList;
}
