package com.elitesland.yst.emdg.inv.dto;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @author jeesie_jiang
 * @description:
 * @datetime 2023年 03月 06日 7:42 下午
 * @version: 1.0
 */
@Data
public class LmInvStkOptBaseRpcDto implements Serializable {
    @ApiModelProperty("库存类型")
    private String limit2;

    @ApiModelProperty("客户编号")
    private String limit1;

    @ApiModelProperty("发运基地Id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long desId;

    @ApiModelProperty("商品ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long itemId;

    @ApiModelProperty("仓库Id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long whId;

    @ApiModelProperty("功能区编号")
    private String deter2;

    @ApiModelProperty("操作数量(数量为正则扣减可供量，为负则可供量增加)")
    private BigDecimal qty;

}
