package com.elitesland.yst.emdg.inv.dto;

import com.elitesland.yst.emdg.inv.util.LmDeter2TypeEnum;
import com.elitesland.yst.emdg.inv.util.LmSrcDocClsEnum;
import com.elitesland.yst.emdg.inv.util.LmStkOptEnum;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @author jeesie_jiang
 * @description:
 * @datetime 2023年 02月 20日 1:42 下午
 * @version: 1.0
 */
@Data
@ApiModel(value = "LmInvStkOptParamVO", description = "库存操作入参")
public class LmInvStkOptRpcDtoParam implements Serializable {

    @ApiModelProperty("库存类型")
    private String limit2;

    @ApiModelProperty("客户编号")
    private String limit1;

    @ApiModelProperty("发运基地Id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long desId;

    @ApiModelProperty("商品ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long itemId;

    @ApiModelProperty("仓库Id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long whId;

    @ApiModelProperty("功能区编号")
    private String deter2;

    @ApiModelProperty("操作数量(数量为正则扣减可供量，为负则可供量增加)")
    private BigDecimal qty;

    @ApiModelProperty("是否启用共享库存，0:不启用 1:启用")
    private Boolean isShare;

    @ApiModelProperty("加购(锁定)/减购（释放） 标志")
    private LmStkOptEnum ioType;

    @ApiModelProperty("功能区类型")
    private LmDeter2TypeEnum deter2Type;

    @ApiModelProperty("购物车号/来源订单号")
    private String srcDocNo;

    @ApiModelProperty("购物车SC/来源订单OD 类别")
    private LmSrcDocClsEnum srcDocCls;

    @ApiModelProperty("请求唯一ID")
    private String requestId;

    @ApiModelProperty("来源 OWNER:自主下单")
    private String source;



}
