package com.elitesland.yst.emdg.inv.dto;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * @author jeesie_jiang
 * @description:
 * @datetime 2023年 02月 22日 2:21 下午
 * @version: 1.0
 */
@Data
@ApiModel(value = "LmInvStkRpcParam", description = "库存可供量查询条件")
public class LmInvStkRpcParam implements Serializable {

    @ApiModelProperty("仓库ID")
    private Long whId;

    @ApiModelProperty("功能区")
    private String deter2;

    @ApiModelProperty("库存类型")
    private String limit2;

    @ApiModelProperty("客户编号")
    private String limit1;

    @ApiModelProperty("客户编号")
    private List<String> limit1s;

    @ApiModelProperty("库存类型")
    private List<String> limit2s;

    @ApiModelProperty("发运基地Id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long desId;

    @ApiModelProperty("商品ID")
    private List<Long> itemIds;

    @ApiModelProperty("功能区集合")
    private List<String> deter2s;



}
