package com.elitesland.yst.emdg.inv.dto;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * @author RYH
 * @date 2024/8/10
 */
@Data
@ApiModel(value = "LmInvStkShareBatchRpcParam", description = "共享库存批量条件查询")
public class LmInvStkShareBatchRpcParam implements Serializable {
    @ApiModelProperty("库存类型")
    private String limit2;

    @ApiModelProperty("客户编号")
    private String limit1;

    @ApiModelProperty("发运基地Id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long desId;

    @ApiModelProperty("商品ID")
    private List<Long> itemIds;

    @ApiModelProperty("功能区类型")
    private String deter2Type;
}
