package com.elitesland.yst.emdg.inv.dto;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * @author jeesie
 * @description:
 * @datetime 2023年 04月 26日 10:01 上午
 * @version: 1.0
 */
@Data
@ApiModel(value = "LmInvWhAreaRpcDto ", description = "立马功能区返回")
public class LmInvWhAreaRpcDto implements Serializable {

    @ApiModelProperty("唯一编号功能区ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long areaId;

    @ApiModelProperty("功能区编码")
    private String deter2;

    @ApiModelProperty("功能区名称")
    private String deter2Name;

    @ApiModelProperty("功能区类型")
    private String deter2Type;

    @ApiModelProperty("仓库ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long whId;

    @ApiModelProperty("公司ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long ouId;

    @ApiModelProperty("仓库编码")
    private String whCode;

    @ApiModelProperty("仓库名称")
    private String whName;

    @ApiModelProperty("发运基地ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long desId;

    @ApiModelProperty("发运基地编码")
    private String desCode;

    @ApiModelProperty("发运基地名称")
    private String desName;

    @ApiModelProperty("地址号 仓库本身的地址号")
    private Long addrNo;
}
