package com.elitesland.yst.emdg.inv.dto;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;


/**
 * <p>
 * 功能说明
 * </p>
 *
 * @author jeesie.jiang
 * @since 2023-06-05 14:00:47
 */
@Data
@ApiModel(value = "lmInvWhRpcDtoParam", description = "仓库及库区查询条件")
public class LmInvWhRpcDtoParam implements Serializable {

    /**
     * 唯一编号ID
     */
    @ApiModelProperty("唯一编号ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long whId;

    /**
     * 公司ID
     */
    @ApiModelProperty("公司ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long ouId;

    @ApiModelProperty("公司ID集合")
    private List<Long> ouIds;

    /**
     * 仓库编号
     */
    @ApiModelProperty("仓库编号")
    private String whCode;

    @ApiModelProperty("仓库ID集合")
    private List<Long> whIds;

    @ApiModelProperty("功能区集合")
    private List<String> deter2s;

    @ApiModelProperty("功能区类型")
    private String deter2Type;

    @ApiModelProperty("仓库编码集合")
    private List<String> whCodes;

    @ApiModelProperty("发运地ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long desId;

    @ApiModelProperty("发运地ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private List<Long> desIds;

    @ApiModelProperty("功能区类型批量查询")
    private List<String> deter2Types;

    @ApiModelProperty("业务管控编码")
    private List<String> bcCodes;






}
