package com.elitesland.yst.emdg.inv.provider;


import com.elitesland.yst.emdg.inv.dto.LmInvWhAreaRpcDto;
import com.elitesland.yst.emdg.inv.dto.LmInvWhRpcDtoParam;
import com.elitesland.yst.emdg.inv.util.LmApplication;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

@Validated
@FeignClient(name = LmApplication.NAME,path = LmApplication.PATH + LmInvWhAreaRpcService.PATH)
public interface LmInvWhAreaRpcService {
    String PATH = "/lmInvWharea";

    @GetMapping("/findAllWhareas")
    List<LmInvWhAreaRpcDto> findAllWhareas();


    /**
     * 查询仓库及库区
     * @return
     */
    @PostMapping("/findWhAreaByParam")
    List<LmInvWhAreaRpcDto> findWhAndWhAreaByParam(@RequestBody LmInvWhRpcDtoParam param);

}
