package com.elitesland.yst.emdg.inv.provider;

import com.elitesland.yst.emdg.inv.dto.InvCustManageDTO;
import com.elitesland.yst.emdg.inv.util.LmApplication;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;

import java.util.List;

/**
 * @author zhiyu.he
 * @date 2023/9/13 17:01
 */
@Validated
@FeignClient(name = LmApplication.NAME,path = LmApplication.PATH + InvCustManageRpcService.PATH)
public interface InvCustManageRpcService {
    String PATH = "/invCustManage";

    /**
     * 根据客户号查询对应基地下单已启用的客户配置
     * @param custCode2
     * @return
     */
    @GetMapping("/queryByCustCode2/{custCode2}")
    List<InvCustManageDTO> queryByCustCode2(@PathVariable("custCode2") String custCode2);
}

