package com.elitesland.yst.emdg.inv.dto;

import com.elitesland.yst.emdg.inv.util.LmSrcDocClsEnum;
import com.elitesland.yst.emdg.inv.util.LmStkOptEnum;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * @author jeesie_jiang
 * @description:
 * @datetime 2023年 03月 06日 7:19 下午
 * @version: 1.0
 */
@Data
public class LmInvStkOptBatchRpcParam implements Serializable {

    @ApiModelProperty("唯一请求ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private String requestId;

    @ApiModelProperty("来源系统")
    private String source;
    @ApiModelProperty("库存操作 标志")
    private LmStkOptEnum ioType;

    @ApiModelProperty("购物车号/来源订单号")
    private String srcDocNo;

    @ApiModelProperty("购物车SC/来源订单OD 类别")
    private LmSrcDocClsEnum srcDocCls;

    private List<LmInvStkOptRpcDtoParam> optRpcDtoParams;
}
