package com.elitesland.yst.emdg.inv.provider;


import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.yst.emdg.inv.dto.*;
import com.elitesland.yst.emdg.inv.util.LmApplication;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;


/**
 * @author jeesie_jiang
 * @description:
 * @datetime 2023年 02月 20日 4:09 下午
 * @version: 1.0
 */
@Validated
@FeignClient(name = LmApplication.NAME,path = LmApplication.PATH + LmInvStkOperateRpcService.PATH)
public interface LmInvStkOperateRpcService {
    String PATH = "/invStkOperate";

    /**
     *共享库存 加购/减购库存
     * @param lmInvStkOptParamVO
     * @return
     */
    @PostMapping("/lmInvStkShareOpt")
    ApiResult<LmInvStkOptResultRpcDto> lmInvStkShareOperate(@RequestBody LmInvStkOptRpcDtoParam lmInvStkOptParamVO);


    /**
     * 购物车批量加购/减购操作库存
     * @param optBatchParamVO 需要传R或T
     * @return 返回满足条件成功扣减的库存明细；
     */
    @PostMapping("/lmInvCartStkOptBatch")
    ApiResult<List<LmInvStkOptBaseRpcDto>> lmInvCartStkOptBatch(@RequestBody LmInvStkOptBatchRpcParam optBatchParamVO);

    /**
     * 查询共享库存可用量
     * 根据库存类型、客户编号、发运基地Id、商品ID 纬度
     * 汇总该纬度下所有仓所有库区的库存总数量
     * @param queryParam
     * @return
     */
    @PostMapping("/getInvStkShareQty")
    LmInvStkShareRpcDto getLmInvStkShareQty(@RequestBody LmInvStkShareRpcParam queryParam);

    /**
     * 批量查询共享库存可用量
     * 根据库存类型、客户编号、发运基地Id、商品ID 纬度
     * 汇总该纬度下所有仓所有库区的库存总数量
     * @param queryParams
     * @return
     */
    @PostMapping("/getInvStkShareQtyBatch")
    List<LmInvStkShareRpcDto> batchGetLmInvStkShareQty(@RequestBody LmInvStkShareBatchRpcParam queryParams);

    /**
     * 根据发运基地查询在库商品信息
     */
    @PostMapping("/getLmInvStkByDesIds")
    List<LmInvStkItemRpcDto> findLmInvStkItemByDesIds(@RequestBody LmInvStkItemRpcParam param);


    /**
     * 批量加购/减购操作库存
     * @param param 需要传R或T
     * @return 如果有一条库存不满足，则整体库存操作失败
     */
    @PostMapping("/lmInvStkOptBatch")
    ApiResult<List<LmInvStkOptBaseRpcDto>> lmInvStkCatchOperateBatch (@RequestBody LmInvStkOptBatchRpcParam param);

    /**
     * 提交订单时候清空购物车，占用数量处理
     * @param cartOccupyRpcParam
     * @return
     */
    @PostMapping("/clearCartOccupyStk")
    ApiResult clearCartOccupyStk(@RequestBody LmInvClearCartOccupyRpcParam cartOccupyRpcParam);













}
