package com.elitesland.yst.emdg.inv.dto;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * @author jeesie_jiang
 * @description:
 * @datetime 2023年 02月 20日 1:42 下午
 * @version: 1.0
 */
@Data
@ApiModel(value = "LmInvStkShareRpcParam", description = "共享库存条件查询")
public class LmInvStkShareRpcParam implements Serializable {

    @ApiModelProperty("库存类型")
    private String limit2;

    @ApiModelProperty("客户编号")
    private String limit1;

    @ApiModelProperty("发运基地Id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long desId;

    @ApiModelProperty("商品ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long itemId;

    @ApiModelProperty("功能区类型")
    private String deter2Type;

}
