package com.elitesland.yst.emdg.inv.dto;

import com.elitescloud.cloudt.common.annotation.SysCode;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serial;
import java.io.Serializable;
import java.util.List;

/**
 * <p>
 * 功能说明:
 * </p>
 *
 * @Author Darren
 * @Date 2025/02/14
 * @Version 1.0
 * @Content:
 */
@Data
public class EmdgInvWhAreaRpcDTO implements Serializable {
    @Serial
    private static final long serialVersionUID = 2097881104077977566L;


    @ApiModelProperty("唯一编号功能区ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long deter2Id;

    @ApiModelProperty("功能区编码")
    private String deter2;

    @ApiModelProperty("功能区名称")
    private String deter2Name;

    @ApiModelProperty("功能区类型")
    private String deter2Type;

    @ApiModelProperty("仓库ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long whId;

    @ApiModelProperty("公司ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long ouId;

    @ApiModelProperty("公司COde")
    private String ouCode;

    @ApiModelProperty("仓库编码")
    private String whCode;

    @ApiModelProperty("仓库名称")
    private String whName;

    @ApiModelProperty("仓库类型（总仓店仓） [UDC]INV:WH_TYPE")
    @SysCode(sys = "yst-inv", mod = "WH_TYPE")
    private String whType;
    private String whTypeName;

    @ApiModelProperty("仓库类型2（一网或者二网） [UDC]yst-sale:DEALER_TYPE2")
    @SysCode(sys = "yst-sale", mod = "DEALER_TYPE2")
    private String whType2;
    private String whType2Name;

    @ApiModelProperty("外部仓库编号")
    private String otherWhCode;

    @ApiModelProperty("是否生成库存账")
    private Boolean generateInvAcc;

    @ApiModelProperty("经销商编码")
    private String dealerCode;
    @ApiModelProperty("经销商Id")
    private Long dealerId;

    @ApiModelProperty("门店code")
    private String storeCode;

    @ApiModelProperty("销售组织编码")
    private Object desCodeJson;

    @ApiModelProperty("销售组织编码集合")
    private List<String> desCodeList;

    @ApiModelProperty("仓库状态")
    @SysCode(sys = "yst-inv", mod = "WH_STATUS")
    private String whStatus;
    private String whStatusName;

    @ApiModelProperty("上级经销商code")
    private String parentDealerCode;
}
