package com.elitesland.yst.emdg.inv.provider;


import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.yst.emdg.inv.dto.LmInvStkRpcDto;
import com.elitesland.yst.emdg.inv.dto.LmInvStkRpcParam;
import com.elitesland.yst.emdg.inv.dto.LmInvStkRpcQueryDto;
import com.elitesland.yst.emdg.inv.dto.LmInvStkRpcQueryParam;
import com.elitesland.yst.emdg.inv.util.LmApplication;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

/**
 * @author jeesie_jiang
 */
@Validated
@FeignClient(name = LmApplication.NAME,path = LmApplication.PATH + LmInvStkRpcService.PATH)
public interface LmInvStkRpcService {
    String PATH = "/invStk";

    @PostMapping("/findInvStkByParam")
    ApiResult<List<LmInvStkRpcDto>> findInvStkByParam(@RequestBody LmInvStkRpcParam param);


    @PostMapping("/enableSku")
    ApiResult<Object> enableSku(@RequestBody List<String> itemCodes);

    @PostMapping("/disableSku")
    ApiResult<Object> disableSku(@RequestBody List<String> itemCodes);


    @PostMapping("/queryStk")
    ApiResult<List<LmInvStkRpcQueryDto>> queryStk(@RequestBody LmInvStkRpcQueryParam lmInvStkRpcQueryParam);


}
