package com.elitesland.yst.emdg.inv.dto;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serial;
import java.io.Serializable;
import java.util.List;

/**
 * <p>
 * 功能说明:
 * </p>
 *
 * @Author Darren
 * @Date 2025/02/05
 * @Version 1.0
 * @Content:
 */
@Data
@ApiModel(value = "emdgInvWhRpcQueryDTO ", description = "仓库RPC入参")
public class EmdgInvWhRpcQueryDTO implements Serializable {
    @Serial
    private static final long serialVersionUID = 6240977597909403490L;


    @ApiModelProperty("唯一编号ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long whId;

    @ApiModelProperty("仓库编号")
    private String whCode;

    @ApiModelProperty("仓库ID集合")
    private List<Long> whIds;

    @ApiModelProperty("仓库编码集合")
    private List<String> whCodes;


    @ApiModelProperty("外部仓库编号")
    private String otherWhCode;

    @ApiModelProperty("外部仓库编码集合")
    private List<String> otherWhCodes;

    @ApiModelProperty("销售组织编码")
    private Object desCodeJson;

    @ApiModelProperty("销售组织编码集合")
    private List<String> desCodeList;
}
