package com.elitesland.yst.emdg.inv.dto;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @author jeesie_jiang
 * @description:
 * @datetime 2023年 02月 22日 2:21 下午
 * @version: 1.0
 */
@Data
@ApiModel(value = "lmInvStkRpcDto", description = "库存可供量查询")
public class LmInvStkRpcDto implements Serializable {

    @ApiModelProperty("库存结存ID")
    private Long id;

    @ApiModelProperty("仓库ID")
    private Long whId;

    @ApiModelProperty("仓库名称")
    private String whName;

    @ApiModelProperty("仓库编码")
    private String whCode;

    @ApiModelProperty("功能区")
    private String deter2;

    @ApiModelProperty("功能区名")
    private String deter2Name;

    @ApiModelProperty("库存类型")
    private String limit2;

    @ApiModelProperty("库存类型名")
    private String limit2Name;

    @ApiModelProperty("客户编号")
    private String limit1;

    @ApiModelProperty("客户号")
    private String es1;

    @ApiModelProperty("客户名")
    private String limit1Name;

    @ApiModelProperty("发运基地Id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long desId;

    @ApiModelProperty("发运基地编码")
    private String desCode;

    @ApiModelProperty("发运基地名")
    private String desName;

    @ApiModelProperty("商品ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long itemId;

    @ApiModelProperty("商品编码")
    private String itemCode;

    @ApiModelProperty("可供量")
    private BigDecimal avalQty;


}
