package com.elitesland.yst.emdg.inv.dto;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * @author jeesie_jiang
 * @description:
 * @datetime 2023年 02月 22日 2:21 下午
 * @version: 1.0
 */
@Data
@ApiModel(value = "LmInvStkRpcQueryParam", description = "库存可供量查询条件")
public class LmInvStkRpcQueryParam implements Serializable {

    @ApiModelProperty("库存类型")
    private String limit2;

    @ApiModelProperty("下单客户编号")
    private String custCode;

    @ApiModelProperty("下单客户号")
    private String custCode2;

    @ApiModelProperty("客户编号")
    private List<String> limit1s;

    @ApiModelProperty("发运基地Id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long desId;

    @ApiModelProperty("商品ID")
    private List<Long> itemIds;

    @ApiModelProperty("功能区类型")
    private String deter2TYpe;
}
