package com.elitesland.yst.emdg.inv.dto;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @author jeesie_jiang
 * @description:
 * @datetime 2023年 02月 22日 2:21 下午
 * @version: 1.0
 */
@Data
@ApiModel(value = "lmInvStkShareRpcDto", description = "共享客户库存信息")
public class LmInvStkShareRpcDto implements Serializable {

    @ApiModelProperty("库存类型")
    private String limit2;

    @ApiModelProperty("客户编号")
    private String limit1;

    @ApiModelProperty("发运基地Id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long desId;

    @ApiModelProperty("商品ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long itemId;

    @ApiModelProperty("可供量")
    private BigDecimal qty;

    @ApiModelProperty("可供量")
    private BigDecimal resQty;
}
