package com.elitesland.yst.emdg.inv.dto;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serial;
import java.io.Serializable;
import java.util.List;

/**
 * <p>
 * 功能说明:
 * </p>
 *
 * @Author Darren
 * @Date 2025/02/14
 * @Version 1.0
 * @Content:
 */
@Data
public class EmdgInvWhAreaRpcQueryDTO implements Serializable {
    @Serial
    private static final long serialVersionUID = -3555971639258202788L;


    @ApiModelProperty("唯一编号ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long whId;

    @ApiModelProperty("公司ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long ouId;

    @ApiModelProperty("公司ID集合")
    private List<Long> ouIds;

    @ApiModelProperty("仓库编号")
    private String whCode;

    @ApiModelProperty("仓库ID集合")
    private List<Long> whIds;

    @ApiModelProperty("功能区集合")
    private List<String> deter2s;

    @ApiModelProperty("功能区类型")
    private String deter2Type;

    @ApiModelProperty("仓库编码集合")
    private List<String> whCodes;

    @ApiModelProperty("发运地ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long desId;

    @ApiModelProperty("发运地ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private List<Long> desIds;

    @ApiModelProperty("功能区类型批量查询")
    private List<String> deter2Types;

    @ApiModelProperty("外部仓库编号")
    private String otherWhCode;

    @ApiModelProperty("外部仓库编码集合")
    private List<String> otherWhCodes;

    @ApiModelProperty("经销商编码")
    private String dealerCode;
    @ApiModelProperty("父亲经销商编码")
    private String parentDealerCode;
    @ApiModelProperty("经销商编码集合")
    private List<String> dealerCodeList;
    @ApiModelProperty("销售组织编码集合")
    private List<String> desCodeList;
}
