package com.elitesland.yst.emdg.inv.dto;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

/**
 * @author jeesie_jiang
 * @description:
 * @datetime 2023年 02月 20日 3:35 下午
 * @version: 1.0
 */
@Data
@ApiModel(value = "LmInvStkOptResultRpcDto", description = "库存操作返回结果")
public class LmInvStkOptResultRpcDto implements Serializable {

    @ApiModelProperty("库存类型")
    private String limit2;

    @ApiModelProperty("客户编号")
    private String limit1;

    @ApiModelProperty("发运基地Id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long desId;

    @ApiModelProperty("商品ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long itemId;

    @ApiModelProperty("扣库信息")
    private List<Body> details;

    @Data
    public static class Body implements Serializable{
        @ApiModelProperty("仓库Id")
        @JsonSerialize(using = ToStringSerializer.class)
        private Long whId;

        @ApiModelProperty("功能区编号")
        private String deter2;

        @ApiModelProperty("操作数量")
        private BigDecimal qty;

        @ApiModelProperty("客户编号")
        private String limit1;
    }



}
