package com.elitesland.yst.emdg.mcae.rpc.param;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

/**
 * @author RYH
 * @date 2024/7/27
 */
@Data
@ApiModel("短信发送参数")
public class SmsSendRpcVO implements Serializable {

    @ApiModelProperty("接收短信的手机号码")
    private String phoneNumbers;

    @ApiModelProperty("短信签名名称")
    private String signName;

    // SMS_XXXXX
    @ApiModelProperty("短信模板Code")
    private String templateCode;

    @ApiModelProperty("短信模板变量对应的实际值(非必填)")
    private Map<String, Object> templateParam = new HashMap<>();

    @ApiModelProperty("上行短信扩展码(非必填)")
    private String smsUpExtendCode;

    @ApiModelProperty("外部流水扩展字段(非必填)")
    private String outId;

}
