package com.elitesland.yst.emdg.mcae.service;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.yst.emdg.mcae.Application;
import com.elitesland.yst.emdg.mcae.rpc.param.ComClgStudentInfoDTO;
import com.elitesland.yst.emdg.mcae.rpc.param.ComClgStudentOrgDTO;
import com.elitesland.yst.emdg.mcae.rpc.param.UpdateEnableVO;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import javax.validation.Valid;
import java.util.List;

/**
 * @author Danny.Wang
 * @title CreateStudentRpcService
 * @Date2023/6/7 13:32
 */
@FeignClient(name = Application.NAME, path = ComClgStudentRpcService.URI)
public interface ComClgStudentRpcService {

    String URI = Application.URI_PREFIX + "/comClgStudent";

    /**
     * 如果学员账号不存在创建学员，否则更新学员信息
     * @param param
     * @return 返回成功执行的学员id
     */
    @PostMapping("/createStudent")
    ApiResult<List<Long>> createStudent(@RequestBody List<@Valid ComClgStudentInfoDTO> param);

    /**
     * 更改学员启用状态 0-禁用 1-启用
     * @param param
     * @return
     */
    @PostMapping("/updateEnable")
    ApiResult<Long> updateEnable(@RequestBody UpdateEnableVO param);


    /**
     * 保存学员组织信息
     * @param param
     * @return
     */
    @PostMapping("/saveStudentOrg")
    ApiResult<Long> saveStudentOrg(@RequestBody List<ComClgStudentOrgDTO> param);

    /**
     * 更新学员最近活跃时间
     * @param studentAccount
     * @return
     */
    @PostMapping("/updateLastActiveTime")
    ApiResult<Long> updateLastActiveTime(String studentAccount);


}
