package com.elitesland.yst.emdg.mcae.rpc.param;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;
import java.util.List;

/**
 * @author Danny.Wang
 * @title ComClgStudentInfoDTO
 * @Date2023/6/7 13:36
 */
@Data
@ApiModel("创建学员入参")
/**
 * 创建学员参数
 */
public class ComClgStudentInfoDTO implements Serializable {

    /**
     * 学员账号/对应的登陆账号
     */
    @NotBlank(message = "学员账号不能为空")
    @ApiModelProperty(value = "学员账号/对应的登陆账号")
    private String studentAccount;

    /**
     *学员名称
     */
    @NotBlank(message = "学员名称不能为空")
    @ApiModelProperty(value = "学员名称")
    private String studentName;

    /**
     *学员类型 UDC:STUDENT_TYPE
     */
    @NotBlank(message = "学员类型不能为空")
    @ApiModelProperty(value = "学员类型 UDC:STUDENT_TYPE")
    private String studentType;

    /**
     * 电话
     */
    @ApiModelProperty(value = "电话")
    private String phone;

    /**
     *区域
     */
    @ApiModelProperty(value = "区域")
    private List<String> region;

    /**
     *所属经销商
     */
    @ApiModelProperty(value = "所属经销商")
    private Long affiliatedDealer;

    /**
     *所属经销商名称
     */
    @ApiModelProperty(value = "所属经销商名称")
    private String affiliatedDealerName;

    /**
     * 启用状态 0-禁用 1-启用
     */
    @ApiModelProperty(value = "启用状态 0-禁用 1-启用")
    private Integer enable;

    /**
     * 组织信息
     */
    @ApiModelProperty(value = "组织信息")
    private List<ComClgStudentOrgDTO> comClgStudentOrgDTOS;


}
