package com.elitesland.yst.emdg.mcae.service;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.yst.emdg.mcae.Application;
import com.elitesland.yst.emdg.mcae.rpc.param.SmsSendRpcVO;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * @description: 短信提醒RPC
 * @author zhengyue
 * @date: 2024/9/19 10:08
 */
@FeignClient(name = Application.NAME, path = SmsOutRpcService.URI)
public interface SmsOutRpcService {
    String URI = Application.URI_PREFIX + "/smsOut";

    /**
     *
     * @param smsSendVO
     * @return 单条发送短信
     */
    @PostMapping("/sendSingleSms")
    ApiResult sendSingleSms(@RequestBody SmsSendRpcVO smsSendVO);

}
