package com.elitesland.yst.emdg.order.rpc;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.yst.emdg.order.Application;
import com.elitesland.yst.emdg.order.rpc.param.query.LmSalesmanDTO;
import com.elitesland.yst.emdg.order.rpc.param.resp.LmSalesmanTargetVO;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

@FeignClient(name = Application.NAME, path = LmSalesmanTargetRpcService.URI)
@Validated
public interface LmSalesmanTargetRpcService {
    String URI = Application.URI_PREFIX + "/salesman";
    @PostMapping("/target")
    ApiResult<List<LmSalesmanTargetVO>> querySalesmanTarget(@RequestBody LmSalesmanDTO param);
}
