package com.elitesland.yst.emdg.sale.rpc.param.query;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serial;
import java.io.Serializable;
import java.util.List;

/**
 * <p>
 * 功能说明:
 * </p>
 *
 * @Author Darren
 * @Date 2024/12/27
 * @Version 1.0
 * @Content:
 */
@Data
@ApiModel(value = "emdgSaleDealerRpcDtoParam ", description = "经销商RPC入参")
public class EmdgSaleDealerRpcQueryDTO implements Serializable {
    @Serial
    private static final long serialVersionUID = -9205328701839824109L;

    @ApiModelProperty("主键ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long id;
    @ApiModelProperty("主键ID集合")
    @JsonSerialize(using = ToStringSerializer.class)
    private List<Long> ids;

    @ApiModelProperty(value = "经销商编码")
    private String dealerCode;
    @ApiModelProperty("经销商编码集合")
    private List<String> dealerCodeList;

    private String dealerCodeKeyword;
    @ApiModelProperty(value = "经销商编码或名称模糊查询")
    private String dealerKeyword;
    @ApiModelProperty(value = "经销商名称")
    private String dealerName;
    @ApiModelProperty(value = "规格组名称模糊查询")
    private String dealerNameKeyWord;

    @ApiModelProperty(value = "经销商类型")
    private String dealerType;
    @ApiModelProperty("经销商类型集合")
    private List<String> dealerTypeList;

    @ApiModelProperty(value = "经销商归类")
    private String dealerClassify;
    @ApiModelProperty("经销商归类集合")
    private List<String> dealerClassifyList;

    @ApiModelProperty(value = "启用状态")
    private String enableFlag;
    @ApiModelProperty("启用状态集合")
    private List<String> enableFlagList;

    @ApiModelProperty("经销商分组集合")
    private List<String> dealerGroupList;

    @ApiModelProperty(value = "销售组织编码集合")
    private List<String> saleOrgList;

    @ApiModelProperty(value = "销售部门集合")
    private List<String> saleDepartmentList;

    @ApiModelProperty(value = "销售大区集合")
    private List<String> saleRegionList;
}
