package com.elitesland.yst.emdg.sale.rpc.param;

import com.elitescloud.cloudt.common.annotation.SysCode;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serial;
import java.io.Serializable;

/**
 * <p>
 * 功能说明:
 * </p>
 *
 * @Author Darren
 * @Date 2024/12/27
 * @Version 1.0
 * @Content:
 */
@Data
@ApiModel(value = "emdgSaleDealerRpcDTO ", description = "经销商RPC出参")
public class EmdgSaleDealerRpcDTO implements Serializable {
    @Serial
    private static final long serialVersionUID = 3889209625212690912L;

    @ApiModelProperty(value = "经销商ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long id;

    @ApiModelProperty(value = "经销商编码")
    private String dealerCode;

    @ApiModelProperty(value = "经销商名称")
    private String dealerName;

    @ApiModelProperty(value = "经销商简称")
    private String dealerShortName;

    @ApiModelProperty(value = "经销商归类 [UDC]yst-sale:CUST_TYPE2")
    @SysCode(sys = "yst-sale", mod = "CUST_TYPE2")
    private String dealerClassify;
    @ApiModelProperty(value = "经销商名称")
    private String dealerClassifyName;

    @ApiModelProperty(value = "经销商类型")
    @SysCode(sys = "yst-sale", mod = "DEALER_TYPE2")
    private String dealerType;
    private String dealerTypeName;

    @ApiModelProperty(value = "经销商分组")
    @SysCode(sys = "yst-sale", mod = "CUST_GROUP")
    private String dealerGroup;
    private String dealerGroupName;

    @ApiModelProperty(value = "经销商等级")
    @SysCode(sys = "yst-sale", mod = "CUST_LEVEL")
    private String dealerLevel;
    private String dealerLevelName;

    @ApiModelProperty(value = "销售组织")
    private String saleOrg;
    @ApiModelProperty(value = "销售组织名称")
    private String saleOrgName;

    @ApiModelProperty(value = "销售部门")
    private String saleDepartment;
    @ApiModelProperty(value = "销售部门名称")
    private String saleDepartmentName;

    @ApiModelProperty(value = "销售大区")
    private String saleRegion;
    @ApiModelProperty(value = "销售大区名称")
    private String saleRegionName;

    @ApiModelProperty(value = "大区经理")
    private String regionalManager;
    @ApiModelProperty(value = "大区经理名称")
    private String regionalManagerName;

    @ApiModelProperty(value = "营销经理")
    private String marketingManager;
    @ApiModelProperty(value = "营销经理名称")
    private String marketingManagerName;

    @ApiModelProperty(value = "装运条件")
    @SysCode(sys = "yst-sale", mod = "DELIVERY_METHOD")
    private String shipmentCondition;
    private String shipmentConditionName;

    @ApiModelProperty(value = "启用状态")
    @SysCode(sys = "yst-sale", mod = "CUST_STATUS")
    private String enableFlag;
    private String enableFlagName;

    @ApiModelProperty(value = "冻结标志")
    @SysCode(sys = "yst-sale", mod = "FREEZE_FLAG")
    private String freezeFlag;
    private String freezeFlagName;

    @ApiModelProperty(value = "过账冻结")
    @SysCode(sys = "yst-sale", mod = "FREEZE_FLAG")
    private String postingFreezeFlag;
    private String postingFreezeFlagName;

    @ApiModelProperty(value = "关联公司ID")
    private Long companyId;

    @ApiModelProperty(value = "关联公司编码")
    private String companyCode;
    @ApiModelProperty(value = "关联公司名称")
    private String companyName;

    @ApiModelProperty(value = "开户公司")
    private String openCompany;
    @ApiModelProperty(value = "开户公司名称")
    private String openCompanyName;
}
