package com.elitesland.yst.emdg.sale.rpc;

import com.elitesland.yst.emdg.sale.Application;
import com.elitesland.yst.emdg.sale.rpc.param.EmdgSaleDealerRpcDTO;
import com.elitesland.yst.emdg.sale.rpc.param.EmdgStoreRpcDTO;
import com.elitesland.yst.emdg.sale.rpc.param.query.EmdgSaleDealerRpcQueryDTO;
import com.elitesland.yst.emdg.sale.rpc.param.query.EmdgStoreRpcQueryDTO;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

/**
 * <p>
 * 功能说明:
 * </p>
 *
 * @Author Darren
 * @Date 2025/01/17
 * @Version 1.0
 * @Content:
 */
@FeignClient(name = Application.NAME, path = EmdgStoreRpcService.URI)
public interface EmdgStoreRpcService {
    String URI = Application.URI_PREFIX + "/saleStore";

    @PostMapping("/selectAllStore")
    List<EmdgStoreRpcDTO> selectAllStore(@RequestBody EmdgStoreRpcQueryDTO param);

    @PostMapping("/selectBaseListByParam")
    List<EmdgStoreRpcDTO> selectBaseListByParam(EmdgStoreRpcQueryDTO param);
}
