package com.elitesland.yst.emdg.sale.rpc;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.yst.emdg.sale.Application;
import com.elitesland.yst.emdg.sale.rpc.param.SaleItemScopeRpcDTO;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * 上架商品rpc service
 *
 * @author : chb
 */
@FeignClient(name = Application.NAME, path = OnShelfItemRpcService.URI)
public interface OnShelfItemRpcService {

    String URI = Application.URI_PREFIX + "/onShelfItem";

    /**
     * 基础域将商品销售范围的更新推送给销售域
     * @param dto 某商品的销售范围
     * @return
     */
    @PostMapping("/pushItemScope")
    ApiResult<Void> pushItemScope(@RequestBody SaleItemScopeRpcDTO dto);
}
