package com.elitesland.yst.emdg.sale.rpc.param.query;

import com.elitescloud.boot.excel.common.param.AbstractExportQueryParam;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.cloudt.common.annotation.SysCode;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serial;
import java.util.List;

/**
 * <p>
 * 功能说明:
 * </p>
 *
 * @Author Darren
 * @Date 2025/04/25
 * @Version 1.0
 * @Content:
 */
@Data
@ApiModel(value = "emdgSaleDealerAuthRangeRpcQueryDTO",description = "经销商授权范围查询参数")
public class EmdgSaleDealerAuthRangeRpcQueryDTO extends AbstractExportQueryParam {
    @Serial
    private static final long serialVersionUID = -2371667047624289580L;


    @ApiModelProperty("主键ID")
    private Long id;
    @ApiModelProperty("主键ID集合")
    private List<Long> ids;

    @ApiModelProperty("主表ID")
    private Long dealerId;
    @ApiModelProperty("主表ID集合")
    private List<Long> dealerIds;

    @ApiModelProperty(value = "经销商名称")
    private String dealerName;

    @ApiModelProperty(value = "经销商编码")
    private String dealerCode;
    @ApiModelProperty("经销商编码集合")
    private List<String> dealerCodeList;

    @ApiModelProperty(value = "销售组织编码")
    private String saleOrgCode;
    @ApiModelProperty("销售组织编码集合")
    private List<String> saleOrgCodeList;

    @ApiModelProperty(value = "营销经理编码")
    private String mktManagerCode;
    @ApiModelProperty("营销经理编码集合")
    private List<String> mktManagerCodeList;

    @ApiModelProperty(value = "销售大区编码")
    private String saleAreaCode;
    @ApiModelProperty("销售大区编码集合")
    private List<String> saleAreaCodeList;

    @ApiModelProperty(value = "大区经理编码")
    private String saleManagerCode;
    @ApiModelProperty("大区经理编码集合")
    private List<String> saleManagerCodeList;

    @ApiModelProperty(value = "业务助理编码")
    private String assistantCode;
    @ApiModelProperty("业务助理编码集合")
    private List<String> assistantCodeList;

    @ApiModelProperty(value = "授权经销类型编码")
    private String authTypeCode;
    @ApiModelProperty("授权经销类型编码集合")
    private List<String> authTypeCodeList;

    @ApiModelProperty(value = "销售公司编码")
    private String saleOuCode;
    @ApiModelProperty("销售公司编码")
    private List<String> saleOuCodeList;

    @ApiModelProperty(value = "销售部门")
    private String saleDepartmentCode;

    @ApiModelProperty(value = "经销商类型")
    private String dealerType;
    @ApiModelProperty("经销商类型集合")
    private List<String> dealerTypeList;

    @ApiModelProperty(value = "经销商归类")
    private String dealerClassify;
    @ApiModelProperty("经销商归类集合")
    private List<String> dealerClassifyList;

    @ApiModelProperty(value = "状态")
    @SysCode(sys = "yst-sale", mod = "FREEZE_FLAG")
    private String status;

    @ApiModelProperty(value = "整车是否可下单")
    private String placeOrder1;

    @ApiModelProperty(value = "广宣品是否可下单")
    private String placeOrder2;

    @ApiModelProperty(value = "配件是否可下单")
    private String placeOrder3;

    @ApiModelProperty(value = "主表启用状态")
    @Comment("主表启用状态 ")
    private String masEnableFlag;

    @ApiModelProperty(value = "主表冻结标志")
    @Comment("主表冻结标志")
    private String masFreezeFlag;

    @ApiModelProperty(value = "主表过账冻结")
    @Comment("主表过账冻结")
    private String masPostingFreezeFlag;

    @ApiModelProperty(value = "是否查询经销商余额")
    private Boolean creditBalanceFlag = false;
    @ApiModelProperty("订单类型3")
    private String docType3;
    private String dealerKeyword;

    @ApiModelProperty("关联公司ID集合")
    private List<Long> companyIds;
    @ApiModelProperty("关联公司编码集合")
    private List<String> companyCodeList;

    @ApiModelProperty("开户公司集合")
    private List<String> openCompanyList;
    @ApiModelProperty(value = "开户公司所属的品牌公司")
    private String brandCompany;

    @ApiModelProperty("白名单标识(钠电品牌是,宗申、淮海品牌不是)")
    private Boolean whiteListFlag;

    @ApiModelProperty(value = "品牌公司")
    private String brandCode;
}
