package com.elitesland.yst.emdg.sale.rpc;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.yst.emdg.sale.Application;
import com.elitesland.yst.emdg.sale.rpc.param.SaleDealerAccountAuthDTO;
import com.elitesland.yst.emdg.sale.rpc.param.SaleDealerAccountAuthRpcVO;
import com.elitesland.yst.emdg.sale.rpc.param.StoreOrderCancelRpcDTO;
import com.elitesland.yst.emdg.sale.rpc.param.StoreOrderDoRpcDTO;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

/**
 * <p>
 * 功能说明:
 * </p>
 *
 * @Author Darren
 * @Date 2025/03/14
 * @Version 1.0
 * @Content:
 */
@FeignClient(name = Application.NAME, path = SaleDealerAccountAuthRpcService.URI)
public interface SaleDealerAccountAuthRpcService {
    String URI = Application.URI_PREFIX + "/saleDealerAccountAuth";


    @PostMapping("/generateAccountAuth")
    ApiResult generateAccountAuth(@RequestBody SaleDealerAccountAuthDTO dto);

    @PostMapping("/getWhCodes")
    List<String> getWhCodes(@RequestBody  String mobile);

    @PostMapping("/getCheckListByDealer")
    List<SaleDealerAccountAuthRpcVO> getCheckListByDealer(@RequestBody String dealerCode);
}
