package com.elitesland.yst.emdg.sale.rpc.param;

import com.elitescloud.boot.excel.common.param.AbstractExportQueryParam;
import com.elitescloud.cloudt.common.annotation.SysCode;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serial;
import java.io.Serializable;
import java.time.LocalDateTime;

@Data
@ApiModel(value = "saleDealerAccountVO",description = "经销商账号")
public class OrderSaleDealerAccountVO extends AbstractExportQueryParam implements Serializable {
    @Serial
    private static final long serialVersionUID = 7163183420736421940L;

    @ApiModelProperty("主键ID")
    private Long id;
    @ApiModelProperty(value = "门店code")
    private String storeCode;

    @ApiModelProperty(value = "门店id")
    private Long storeId;

    @ApiModelProperty(value = "门店名称")
    private String storeName;

    @ApiModelProperty(value = "销售组织编码")
    private String buCode;
    @ApiModelProperty(value = "经销商code")
    private String dealerCode;

    @ApiModelProperty(value = "经销商名称")
    private String dealerName;

    @ApiModelProperty(value = "经销商id")
    private Long dealerId;

    @ApiModelProperty(value = "性别，（male-男，female-女，secret-保密）")
    private String gender;


    @ApiModelProperty(value = "手机号")
    private String mobile;


    @ApiModelProperty(value = "姓名")
    private String name;


    @ApiModelProperty(value = "角色code逗号分割")
    private String roleCode;

    @ApiModelProperty(value = "角色id逗号分割")
    private String roleId;

    @ApiModelProperty(value = "角色Name逗号分割")
    private String roleName;


    @ApiModelProperty("状态，true启用，false禁用")
    private Boolean enabled;

    @ApiModelProperty("创建人ID")
    private Long createUserId;

    @ApiModelProperty("创建人")
    private String creator;

    @ApiModelProperty("创建时间")
    private LocalDateTime createTime;

    private String keyword;

    @SysCode(sys = "yst-fin",mod = "TRANSFER_STATE")
    @ApiModelProperty("创建人")
    private String businessKey;
    private String businessKeyName;

    @ApiModelProperty(value = "开户公司")
    private String openCompany;

    @ApiModelProperty(value = "开户公司名称")
    private String openCompanyName;

    @ApiModelProperty("白名单标识(钠电品牌是,宗申、淮海品牌不是)")
    private Boolean whiteListFlag;

}
