package com.elitesland.yst.emdg.sale.rpc.param;

import com.elitescloud.boot.common.param.BaseViewModel;
import com.elitescloud.cloudt.common.annotation.SysCode;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serial;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

/**
 * <p>
 * 功能说明:
 * </p>
 *
 * @Author Darren
 * @Date 2025/04/25
 * @Version 1.0
 * @Content:
 */
@Data
@ApiModel(value = "emdgSaleDealerAuthRangeRpcDTO", description = "经销商授权范围详情出参")
public class EmdgSaleDealerAuthRangeRpcDTO extends BaseViewModel implements Serializable {
    @Serial
    private static final long serialVersionUID = -4611261475171174703L;


    @ApiModelProperty(value = "主键")
    private Long id;

    @ApiModelProperty(value = "经销商id")
    private Long dealerId;

    @ApiModelProperty(value = "经销商编码")
    private String dealerCode;

    @ApiModelProperty(value = "经销商名称")
    private String dealerName;

    @ApiModelProperty(value = "授权明细行行号")
    private Integer lineNo;

    @ApiModelProperty(value = "销售组织id")
    private Long saleOrgId;
    @ApiModelProperty(value = "销售组织编码")
    private String saleOrgCode;

    @ApiModelProperty(value = "销售组织名称")
    private String saleOrgName;

    @ApiModelProperty("销售组织上级的上级编码")
    private String superiorsCode;
    @ApiModelProperty("销售组织上级编码")
    private String parentCode;
    @ApiModelProperty("销售组织上级名称")
    private String parentCodeName;

    @ApiModelProperty(value = "销售组织关联的所属公司id")
    private Long belongOuId;
    @ApiModelProperty(value = "销售组织关联的所属公司编码【页面不展示】")
    private String belongOuCode;
    @ApiModelProperty(value = "销售组织关联的所属公司名称")
    private String belongOuName;

    @ApiModelProperty(value = "销售公司id")
    private Long saleOuId;
    @ApiModelProperty(value = "销售公司编码")
    private String saleOuCode;

    @ApiModelProperty(value = "销售公司名称")
    private String saleOuName;
    @ApiModelProperty(value = "销售公司的BU的ID")
    private Long ouBuId;
    @ApiModelProperty(value = "销售公司的BU的编码")
    private String ouBuCode;
    @ApiModelProperty(value = "销售公司的BU的名称")
    private String ouBuName;

    @ApiModelProperty(value = "品牌公司id")
    private Long brandId;
    @ApiModelProperty(value = "品牌编码")
    private String brandCode;

    @ApiModelProperty(value = "品牌公司虚拟组织品牌名称")
    private String brandName;

    @ApiModelProperty(value = "销售部门编码")
    private String saleDepartmentCode;

    @ApiModelProperty(value = "销售部门名称")
    private String saleDepartmentName;

    @ApiModelProperty(value = "销售大区id")
    private Long saleRegionId;
    @ApiModelProperty(value = "销售大区编码")
    private String saleAreaCode;

    @ApiModelProperty(value = "销售大区名称")
    private String saleAreaName;

    @ApiModelProperty(value = "大区经理编码")
    private String saleManagerCode;

    @ApiModelProperty(value = "大区经理姓名")
    private String saleManagerName;

    @ApiModelProperty(value = "营销经理编码")
    private String mktManagerCode;

    @ApiModelProperty(value = "营销经理姓名")
    private String mktManagerName;

    @ApiModelProperty(value = "业务助理编码")
    private String assistantCode;

    @ApiModelProperty(value = "业务助理姓名")
    private String assistantName;


    @ApiModelProperty(value = "授权经销类型编码")
    private String authTypeCodes;

    @ApiModelProperty(value = "授权经销类型名称，多个，用都好分割连接")
    private String authTypeNames;

    @ApiModelProperty(value = "授权区域编码，多个，用逗号分割连接，来自sys_platform_area表的area_code")
    private String saleAreaCodes;

    @ApiModelProperty(value = "授权区域名称，多个，用逗号分割连接，来自sys_platform_area表的area_name")
    private String saleAreaNames;

    @ApiModelProperty(value = "整车授权范围编码，多个，用逗号分割连接，来自itm_item_cate表，item_cate_type ='10'的item_cate_code")
    private String authVehicleCodes;
    @ApiModelProperty(value = "整车授权范围商品品类编码集合")
    private List<String> authVehicleCodeList;

    @ApiModelProperty(value = "整车授权范围名称，多个，用逗号分割连接，来自itm_item_cate表，item_cate_type ='10'的item_cate_name")
    private String authVehicleNames;

    @ApiModelProperty(value = "配件授权范围编码，多个，用逗号分割连接，来自itm_item_cate表，item_cate_type ='20'的item_cate_code")
    private String authPartCodes;
    @ApiModelProperty(value = "配件授权范围商品品类编码集合")
    private List<String> authPartCodeList;

    @ApiModelProperty(value = "配件授权范围名称，多个，用逗号分割连接，来自itm_item_cate表，item_cate_type ='20'的item_cate_name")
    private String authPartNames;

    @ApiModelProperty(value = "广宣品授权范围编码，多个，用逗号分割连接，来自itm_item_cate表，item_cate_type ='40'的item_cate_code")
    private String authAdsmatCodes;
    @ApiModelProperty(value = "广宣品授权范围商品品类编码集合")
    private List<String> authAdsmatCodeList;

    @ApiModelProperty(value = "广宣品授权范围名称，多个，用逗号分割连接，来自itm_item_cate表，item_cate_type ='40'的item_cate_name")
    private String authAdsmatNames;

    @ApiModelProperty(value = "状态")
    @SysCode(sys = "yst-sale", mod = "FREEZE_FLAG")
    private String status;
    @ApiModelProperty(value = "状态名称")
    private String statusName;

    @ApiModelProperty(value = "整车是否可下单")
    private String placeOrder1;

    @ApiModelProperty(value = "广宣品是否可下单")
    private String placeOrder2;

    @ApiModelProperty(value = "配件是否可下单")
    private String placeOrder3;


    @ApiModelProperty(value = "经销商类型")
    @SysCode(sys = "yst-sale", mod = "DEALER_TYPE2")
    private String dealerType;
    private String dealerTypeName;

    @ApiModelProperty(value = "经销商等级")
    @SysCode(sys = "yst-sale", mod = "CUST_LEVEL")
    private String dealerLevel;
    private String dealerLevelName;

    @ApiModelProperty(value = "任意授权品类编码，用于前端回显使用")
    private String authorizationItemCateCode;
    @ApiModelProperty(value = "任意授权品类名称，用于前端回显使用")
    private String authorizationItemCateName;
    @ApiModelProperty(value = "可用余额")
    private BigDecimal dealerBalance;


    @ApiModelProperty(value = "营销经理")
    private String marketingManager;
    @ApiModelProperty(value = "营销经理名称")
    private String marketingManagerName;

    @ApiModelProperty(value = "开户公司")
    private String openCompany;
    @ApiModelProperty(value = "开户公司名称")
    private String openCompanyName;

    @ApiModelProperty(value = "开户公司上级组织品牌")
    private String openCompanyBrand;
    @ApiModelProperty(value = "开户公司上级组织品牌名称")
    private String openCompanyBrandName;
}
