package com.elitesland.yst.emdg.sale.rpc;

import com.elitesland.yst.emdg.sale.Application;
import com.elitesland.yst.emdg.sale.rpc.param.EmdgSaleDealerAccountRpcDTO;
import com.elitesland.yst.emdg.sale.rpc.param.EmdgSaleDealerAuthRangeRpcDTO;
import com.elitesland.yst.emdg.sale.rpc.param.EmdgSaleDealerRpcDTO;
import com.elitesland.yst.emdg.sale.rpc.param.query.EmdgSaleDealerAuthRangeRpcQueryDTO;
import com.elitesland.yst.emdg.sale.rpc.param.query.EmdgSaleDealerRpcQueryDTO;
import com.elitesland.yst.emdg.sale.rpc.param.query.OrderSaleDealerAccountVO;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

/**
 * <p>
 * 功能说明:
 * </p>
 *
 * @Author Darren
 * @Date 2024/12/27
 * @Version 1.0
 * @Content:
 */
@FeignClient(name = Application.NAME, path = EmdgSaleDealerRpcService.URI)
public interface EmdgSaleDealerRpcService {

    String URI = Application.URI_PREFIX + "/saleDealer";

    @PostMapping("/searchSaleDealer")
    List<EmdgSaleDealerRpcDTO> searchSaleDealer(@RequestBody EmdgSaleDealerRpcQueryDTO param);

    @PostMapping("/createDealerAccount")
    EmdgSaleDealerAccountRpcDTO createDealerAccount(@RequestBody EmdgSaleDealerAccountRpcDTO param);


    @PostMapping("/queryDealerAccount")
    List<OrderSaleDealerAccountVO> queryDealerAccount(@RequestBody OrderSaleDealerAccountVO param);

    @PostMapping("/selectAllDealer")
    List<EmdgSaleDealerRpcDTO> selectAllDealer(@RequestBody EmdgSaleDealerRpcQueryDTO param);

    @PostMapping("/selectByAuthRange")
    List<EmdgSaleDealerRpcDTO> selectByAuthRange(@RequestBody EmdgSaleDealerRpcQueryDTO param);

    @PostMapping("/selectSaleDealerBaseByParam")
    List<EmdgSaleDealerRpcDTO> selectSaleDealerBaseByParam(@RequestBody EmdgSaleDealerRpcQueryDTO param);

    @PostMapping("/selectAuthRangeByParam")
    List<EmdgSaleDealerAuthRangeRpcDTO> selectAuthRangeByParam(@RequestBody EmdgSaleDealerAuthRangeRpcQueryDTO param);

    @PostMapping("/updatePlaceOrder1ByDealerCodeAndSaleOrgCode")
    void updatePlaceOrder1ByDealerCodeAndSaleOrgCode(@RequestBody EmdgSaleDealerAuthRangeRpcQueryDTO param);

    @PostMapping("/updatePlaceOrder2ByDealerCodeAndSaleOrgCode")
    void updatePlaceOrder2ByDealerCodeAndSaleOrgCode(@RequestBody EmdgSaleDealerAuthRangeRpcQueryDTO param);

    @PostMapping("/updatePlaceOrder3ByDealerCodeAndSaleOrgCode")
    void updatePlaceOrder3ByDealerCodeAndSaleOrgCode(@RequestBody EmdgSaleDealerAuthRangeRpcQueryDTO param);
}
