package com.elitesland.yst.emdg.sale.rpc.param;

import com.elitescloud.cloudt.common.annotation.SysCode;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * 经销商账号权限 vo
 */
@Data
@ApiModel(description = "经销商账号权限")
public class SaleDealerAccountAuthRpcVO implements Serializable{



  @ApiModelProperty(value = "主键")
  private Long id;

  @ApiModelProperty(value = "来源")
  private String source;

  @ApiModelProperty(value = "门店code")
  private String storeCode;

  @ApiModelProperty(value = "门店id")
  private Long storeId;

  @ApiModelProperty(value = "门店Name")
  private String storeName;

  @ApiModelProperty(value = "经销商code")
  private String dealerCode;

  @ApiModelProperty(value = "经销商Name")
  private String dealerName;

  @ApiModelProperty(value = "经销商id")
  private Long dealerId;

  @ApiModelProperty(value = "经销商类型")
  @SysCode(sys = "yst-sale", mod = "DEALER_TYPE2")
  private String dealerType;
  private String dealerTypeName;

  @ApiModelProperty(value = "仓库code")
  private String whCode;

  @ApiModelProperty(value = "仓库ID")
  private Long whId;

  @ApiModelProperty(value = "仓库name")
  private String whName;

  @SysCode(sys = "yst-inv", mod = "WH_TYPE")
  @ApiModelProperty(value = "仓库类型")
  private String whType;


  @ApiModelProperty(value = "仓库类型 [UDC]INV:WH_TYPE")
  private String whTypeName;



  @ApiModelProperty(value = "是否启用")
  private Boolean enabled;


  @ApiModelProperty(value = "是否勾选 0 未勾选 1勾选")
  private String checked;

  @ApiModelProperty("仓库状态")
  @SysCode(sys = "yst-inv", mod = "WH_STATUS")
  private String whStatus;
  private String whStatusName;

}
