package com.elitesland.yst.emdg.support.provider.ou.dto;


import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;


/**
 * @author gongyijie
 * @date 2023-03-28
 */
@Data
@ApiModel("公司查询返回参数")
public class OrgOuRpcDTO implements Serializable {

    private static final long serialVersionUID = -1948926768080959006L;

    /**
     * 公司编号
     */
    @ApiModelProperty(value = "公司编号")
    private String ouCode;

    /**
     * 公司名称
     */
    @ApiModelProperty(value = "公司名称")
    private String ouName;

    /**
     * 公司名称2
     */
    @ApiModelProperty(value = "公司名称2")
    private String ouName2;

    /**
     * 公司名称3
     */
    @ApiModelProperty(value = "公司名称3")
    private String ouName3;

    /**
     * 公司名称4
     */
    @ApiModelProperty(value = "公司名称4")
    private String ouName4;

    /**
     * 公司简称
     */
    @ApiModelProperty(value = "公司简称")
    private String ouAbbr;

    /**
     * 字母缩写
     */
    @ApiModelProperty(value = "字母缩写")
    private String abbrAlpha;

    /**
     * 公司类型 [UDC]ORG:OU_TYPE
     */
    @ApiModelProperty(value = "公司类型 [UDC]ORG:OU_TYPE")
    private String ouType;

    /**
     * 公司类型2
     */
    @ApiModelProperty(value = "公司类型2")
    private String ouType2;

    /**
     * 公司类型3
     */
    @ApiModelProperty(value = "公司类型3")
    private String ouType3;

    /**
     * 公司状态 [UDC]COM:STATUS_ACTIVEORNO
     */
    @ApiModelProperty(value = "公司状态 [UDC]COM:STATUS_ACTIVEORNO")
    private String ouStatus;

    /**
     * 公司状态2
     */
    @ApiModelProperty(value = "公司状态2")
    private String ouStatus2;

    /**
     * 公司状态3
     */
    @ApiModelProperty(value = "公司状态3")
    private String ouStatus3;

    /**
     * 经营单位ID
     */
    @ApiModelProperty(value = "经营单位ID")
    private Long buId;

    /**
     * BU编号
     */
    @ApiModelProperty(value = "BU编号")
    private String buCode;

    /**
     * BU名称
     */
    @ApiModelProperty(value = "BU名称")
    private String buName;

    /**
     * 上级ID
     */
    @ApiModelProperty(value = "上级ID")
    private Long pid;

    /**
     * 上级组织名称
     */
    @ApiModelProperty(value = "上级组织名称")
    private String pname;

    /**
     * 法人公司ID
     */
    @ApiModelProperty(value = "法人公司ID")
    private Long legalOuId;

    /**
     * 法人公司名称
     */
    @ApiModelProperty(value = "法人公司名称")
    private String legalOuName;

    /**
     * 路径
     */
    @ApiModelProperty(value = "路径")
    private String ouPath;

    /**
     * 本位币
     */
    @ApiModelProperty(value = "本位币")
    private String ouCurr;

    /**
     * 财务日历编号
     */
    @ApiModelProperty(value = "财务日历编号")
    private String finCalCode;

    /**
     * 财务年度
     */
    @ApiModelProperty(value = "财务年度")
    private Integer finYear;

    /**
     * 财务期间
     */
    @ApiModelProperty(value = "财务期间")
    private Integer finPeriod;

    /**
     * 地址号
     */
    @ApiModelProperty(value = "地址号")
    private Long addrNo;

    /**
     * 国家 [UDC]COM:COUNTRY
     */
    @ApiModelProperty(value = "国家 [UDC]COM:COUNTRY")
    private String country;

    /**
     * 区域 [UDC]ORG:OU_REGION
     */
    @ApiModelProperty(value = "区域 [UDC]ORG:OU_REGION")
    private String region;

    /**
     * 排序号 用于相同层级的排序
     */
    @ApiModelProperty(value = "排序号 用于相同层级的排序")
    private Integer sortNo;

    /**
     * 组织机构代码证号
     */
    @ApiModelProperty(value = "组织机构代码证号")
    private String bizCodeCert;

    /**
     * 工商登记号
     */
    @ApiModelProperty(value = "工商登记号")
    private String icRegisterNo;

    /**
     * 统一信用代码
     */
    @ApiModelProperty(value = "统一信用代码")
    private String uniCertNo;

    /**
     * 分销渠道
     */
    @ApiModelProperty(value = "分销渠道")
    private String saleChannel;

    /**
     * 外部系统类型
     */
    @ApiModelProperty(value = "外部系统类型")
    private String outerSysType;

    /**
     * 法人代表
     */
    @ApiModelProperty(value = "法人代表")
    private String reprName;

    /**
     * 税务登记号
     */
    @ApiModelProperty(value = "税务登记号")
    private String taxRegNo;

    /**
     * 纳税人类型
     */
    @ApiModelProperty(value = "纳税人类型")
    private String taxpayerType;

    /**
     * 纳税人识别号
     */
    @ApiModelProperty(value = "纳税人识别号")
    private String taxerCode;

    /**
     * 发票类型
     */
    @ApiModelProperty(value = "发票类型")
    private String invType;

    /**
     * 开票抬头
     */
    @ApiModelProperty(value = "开票抬头")
    private String invTitle;

    /**
     * 开票地址
     */
    @ApiModelProperty(value = "开票地址")
    private String invAddress;

    /**
     * 开票电话
     */
    @ApiModelProperty(value = "开票电话")
    private String invTel;

    /**
     * 开票联系人
     */
    @ApiModelProperty(value = "开票联系人")
    private String invPicName;

    /**
     * 开票联系人电话
     */
    @ApiModelProperty(value = "开票联系人电话")
    private String invPicPhone;

    /**
     * 开票银行名称
     */
    @ApiModelProperty(value = "开票银行名称")
    private String invBankName;

    /**
     * 开票银行支行
     */
    @ApiModelProperty(value = "开票银行支行")
    private String invBankBranch;

    /**
     * 开票银行账号
     */
    @ApiModelProperty(value = "开票银行账号")
    private String invBankAcc;

    /**
     * 税率编号
     */
    @ApiModelProperty(value = "税率编号")
    private String taxRateNo;

    /**
     * 税率
     */
    @ApiModelProperty(value = "税率")
    private BigDecimal taxRate;

    /**
     * 类别码
     */
    @ApiModelProperty(value = "类别码")
    String cat;

    /**
     * 类别码2
     */
    @ApiModelProperty(value = "类别码2")
    String cat2;

    /**
     * 类别码3
     */
    @ApiModelProperty(value = "类别码3")
    String cat3;

    /**
     * 类别码4
     */
    @ApiModelProperty(value = "类别码4")
    String cat4;

    /**
     * 类别码5
     */
    @ApiModelProperty(value = "类别码5")
    String cat5;

    /**
     * 类别码6
     */
    @ApiModelProperty(value = "类别码6")
    String cat6;

    /**
     * 类别码7
     */
    @ApiModelProperty(value = "类别码7")
    String cat7;

    /**
     * 类别码8
     */
    @ApiModelProperty(value = "类别码8")
    String cat8;

    /**
     * 类别码9
     */
    @ApiModelProperty(value = "类别码9")
    String cat9;

    /**
     * 类别码10
     */
    @ApiModelProperty(value = "类别码10")
    String cat10;

    /**
     * 类别码11
     */
    @ApiModelProperty(value = "类别码11")
    String cat11;

    /**
     * 类别码12
     */
    @ApiModelProperty(value = "类别码12")
    String cat12;

    /**
     * 类别码13
     */
    @ApiModelProperty(value = "类别码13")
    String cat13;

    /**
     * 类别码14
     */
    @ApiModelProperty(value = "类别码14")
    String cat14;

    /**
     * 类别码15
     */
    @ApiModelProperty(value = "类别码15")
    String cat15;

    /**
     * 类别码16
     */
    @ApiModelProperty(value = "类别码16")
    String cat16;

    /**
     * 类别码17
     */
    @ApiModelProperty(value = "类别码17")
    String cat17;

    /**
     * 类别码18
     */
    @ApiModelProperty(value = "类别码18")
    String cat18;

    /**
     * 类别码19
     */
    @ApiModelProperty(value = "类别码19")
    String cat19;

    /**
     * 类别码20
     */
    @ApiModelProperty(value = "类别码20")
    String cat20;

    /**
     * 核算编码
     */
    @ApiModelProperty(value = "核算编码")
    private String externalCode;

    /**
     * 是否新建组织
     */
    @ApiModelProperty(value = "是否新建组织")
    private boolean selectedCreateOu;
}
