package com.elitesland.yst.emdg.support.provider.ou.service;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.yst.emdg.support.Application;
import com.elitesland.yst.emdg.support.provider.ou.dto.OrgOuRpcDTO;
import com.elitesland.yst.emdg.support.provider.ou.dto.OrgOuRpcSimpleDTO;
import com.elitesland.yst.emdg.support.provider.ou.dto.OrgTradeOuRpcDTO;
import com.elitesland.yst.emdg.support.provider.ou.param.ItmOrgOuRpcDtoParam;
import com.elitesland.yst.emdg.support.provider.ou.param.QueryOuByBuIdParamVO;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;


@FeignClient(name = Application.NAME, path = Application.PATH + OrgOuRpcService.PATH)
@Validated
public interface OrgOuRpcService {
    String PATH = "/orgOuRpc";

    /**
     * 根据门店编号查询公司信息
     */
    @PostMapping("/queryOuMsg")
    List<OrgOuRpcDTO> queryOuMsg(@RequestBody ItmOrgOuRpcDtoParam param);

    /**
     * 根据buid查询公司信息
     * @param param
     * @return
     */
    @PostMapping("/queryOuByBuId")
    ApiResult<List<OrgOuRpcSimpleDTO>> queryOuByBuId(@RequestBody QueryOuByBuIdParamVO param);

    /**
     * 查询公司绑定的贸易公司
     * @param ouCode
     * @return
     */
    @PostMapping("/queryTradeOu")
    ApiResult<OrgTradeOuRpcDTO> queryTradeOuByOuCode(@RequestParam("ouCode") String ouCode);
}
