package com.elitesland.yst.emdg.support.provider.price.param;

import com.elitescloud.boot.common.param.AbstractOrderQueryParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.time.LocalDateTime;

@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
@ApiModel("商品价格查询条件")
public class ItmPriPricePagingRpcDtoParam extends AbstractOrderQueryParam implements Serializable {

    private static final long serialVersionUID = -4338427891182297120L;

    @ApiModelProperty("商品ID列表")
    private Long itemId;

    @ApiModelProperty("商品编号列表")
    private String itemCode;

    @ApiModelProperty(value = "销售组织")
    private String saleOrg;

    @ApiModelProperty(value = "价格类型 [UDC]yst-support: PRICE_TYPE")
    private String priceType;

    @ApiModelProperty(value = "渠道类型 [UDC]yst-support: CHANNEL_TYPE")
    private String channelType;

    @ApiModelProperty(value = "分销渠道")
    private String saleChannel;

    @ApiModelProperty(value = "客户编码")
    private String custKey;

    @ApiModelProperty(value = "客户区域 [UDC]yst-support: REGION")
    private String region;

//    @ApiModelProperty(value = "商品类型 [UDC]yst-support: ITEM_TYPE2")
//    private String itemType2;

    @ApiModelProperty(value = "整车类型 [UDC]yst-support: ITEM_TYPE3")
    private String itemType3;

    @ApiModelProperty(value = "整车定位")
    private String itemPosit;

    @ApiModelProperty(value = "包装方式 [UDC]yst-support: PACK_DEMAND")
    private String packDemand;

    @ApiModelProperty(value = "系列 [UDC]yst-support: ITEM_GROUP")
    private String itemGroup;

    @ApiModelProperty(value = "生产基地 [UDC]yst-support: ORIGIN")
    private String origin;

    @ApiModelProperty(value = "发货基地")
    private String desCode;

    @ApiModelProperty("生效时间点，用于查询指定生效时间点的数据")
    private LocalDateTime validTime;

    @ApiModelProperty("生效时间，时间区间开始，大于等于")
    private LocalDateTime effectiveDatetime;

    @ApiModelProperty("失效时间，时间区间结束，小于等于")
    private LocalDateTime expiryDatetime;

    @ApiModelProperty(value = "价格状态")
    private String priceStatus;

}
