package com.elitesland.yst.emdg.support.provider.item.service;

import com.elitesland.yst.emdg.support.Application;
import com.elitesland.yst.emdg.support.provider.item.dto.ItmReceivingCfgRpcDTO;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

@FeignClient(name = Application.NAME, path = Application.PATH + ItemReceivingCfgRpcService.PATH)
@Validated
public interface ItemReceivingCfgRpcService {

    String PATH = "/lm/itm/receiving/rpc";

    /**
     * @description: 根据配件类型批量查询
     * @param: types 配件类型
     * @return: ItmItemReceivingConfigDTO 配件收料方式配置集合
     * @author zhengyue
     * @date: 2023/11/28 10:51
     */
    @PostMapping("/batchQueryByType")
    List<ItmReceivingCfgRpcDTO> batchQueryByItemCode(@RequestBody List<String> itemCodes);

}
