package com.elitesland.yst.emdg.support.provider.item.dto;

import com.elitescloud.cloudt.common.annotation.SysCode;
import com.elitesland.yst.production.support.core.infr.dto.item.ItmItemTagDTO;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serial;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

/**
 * <p>
 * 功能说明:
 * </p>
 *
 * @Author Darren
 * @Date 2024/12/31
 * @Version 1.0
 * @Content:
 */
@Data
@ApiModel(value = "emdgItemCommonRpcDTO ", description = "商品公共基础查询RPC出参")
public class EmdgItemCommonRpcDTO implements Serializable {
    @Serial
    private static final long serialVersionUID = -8139550321392867699L;

    @ApiModelProperty("商品SKU的ID")
    private Long id;

    @ApiModelProperty("商品SKU的编码")
    private String itemCode;

    @ApiModelProperty("商品SKU的名称")
    private String itemName;

    @ApiModelProperty("内部公告号")
    private String es4;

    @ApiModelProperty("外部公告号")
    private String es5;

    @ApiModelProperty("商城上架状态")
    @SysCode(sys = "yst-supp", mod = "UP_DOWN_STATUS")
    private String es7;
    @ApiModelProperty("商城上架状态")
    private String es7Name;

    @ApiModelProperty("商品状态")
    @SysCode(sys = "yst-supp", mod = "ITEM_STATUS")
    private String itemStatus3;
    private String itemStatusName3;

    @SysCode(sys = "yst-supp", mod = "UOM")
    @ApiModelProperty("主计量单位 [UDC]COM:UOM")
    private String uom;
    private String uomName;

    @ApiModelProperty("老物料编码")
    private String itemCodeHis;

    @ApiModelProperty("车辆颜色SAP编码")
    private String es2;
    @ApiModelProperty("车辆颜色名称")
    private String es2Name;
    /********************************************/
    @ApiModelProperty("spuId")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long spuId;

    @ApiModelProperty("SPU编号")
    private String spuCode;

    @ApiModelProperty("SPU名称")
    private String spuName;

    @ApiModelProperty(value = "物料类型/商品分类 [UDC]yst-supp:ITEM_TYPE2")
    @SysCode(sys = "yst-supp", mod = "ITEM_TYPE2")
    private String itemType2;
    private String itemType2Name;

    @ApiModelProperty(value = "物料类型/车辆类型 [UDC]yst-supp:ITEM_TYPE5")
    @SysCode(sys = "yst-supp", mod = "ITEM_TYPE5")
    private String itemType5;
    private String itemType5Name;

    @ApiModelProperty("规格")
    private String spec;

    @ApiModelProperty("商品描述")
    private String es3;

    @ApiModelProperty(value = "销售组织ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long buId;

    @ApiModelProperty("销售组织")
    private String buCode;

    @ApiModelProperty(value = "销售组织名称")
    private String buName;

    @ApiModelProperty("销售工厂ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long manuerId;

    @ApiModelProperty("销售工厂")
    private String manuerCode;

    @ApiModelProperty("销售工厂名称")
    private String manuerName;

    @ApiModelProperty("品类(SPU)编号")
    private String itemCateCode;
    @ApiModelProperty("品类编号/二级品类全称")
    private String itemCateCodeName;
    @ApiModelProperty(value = "一级品系")
    private String itemCateCode2;
    @ApiModelProperty("一级品系全称")
    private String itemCateCode2Name;

    @ApiModelProperty("SPU维度的商城上架状态")
    @SysCode(sys = "yst-supp", mod = "UP_DOWN_STATUS")
    private String es8;
    private String es8Name;

    @ApiModelProperty(value = " SPU维度的商品状态")
    @SysCode(sys = "yst-supp", mod = "ITEM_STATUS")
    private String es9;
    private String es9Name;

    @ApiModelProperty("分销渠道")
    @SysCode(sys = "yst-supp", mod = "SALE_CHANNEL")
    private String cat4;
    private String cat4Name;
    /********************************************/


    @ApiModelProperty("SKU商品标签")
    private List<EmdgItemTagRpcDTO> itemTagList;

    @ApiModelProperty(value = "SKU默认图片")
    private String skuDefaultUrl;
}
