package com.elitesland.yst.emdg.support.provider.price.dto;

import com.elitescloud.boot.common.param.BaseViewModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serial;
import java.io.Serializable;
import java.math.BigDecimal;

/**
 * <p>
 * 功能说明:
 * </p>
 *
 * @Author Darren
 * @Date 2025/03/28
 * @Version 1.0
 * @Content:
 */
@Data
@ApiModel(value = "emdgNdSalePriceRpcDTO ", description = "钠电销售价格RPC出参")
public class EmdgNdSalePriceRpcDTO extends BaseViewModel implements Serializable {

    @Serial
    private static final long serialVersionUID = -3787379469728190826L;

    @ApiModelProperty("是否获取到价格标识")
    private Boolean successFlag = false;

    @ApiModelProperty("销售组织编码")
    private String deter1;

    @ApiModelProperty("经销商编码")
    private String deter3;

    @ApiModelProperty("销售公司编码")
    private String deter5;

    @ApiModelProperty(value = "商品SKU编码")
    private String itemCode;


    @ApiModelProperty("钠电的价格(元)")
    private BigDecimal price;

    @ApiModelProperty("基地销售价/钠电销售参考价(元)")
    private BigDecimal salePrice;

    @ApiModelProperty("基地直降价/钠电直降参考价(元)")
    private BigDecimal lapseSalePrice;

    @ApiModelProperty("基地选配差额价/钠电选配差额参考价(元)")
    private BigDecimal differencePrice;

    @ApiModelProperty("基地财务调整价/钠电财务调整参考价(元)")
    private BigDecimal finAdjustPrice;
}
