package com.elitesland.yst.emdg.support.provider.price.dto;

import com.elitescloud.boot.common.param.BaseViewModel;
import com.elitescloud.cloudt.common.annotation.SysCode;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serial;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * <p>
 * 功能说明:
 * </p>
 *
 * @Author Darren
 * @Date 2025/03/28
 * @Version 1.0
 * @Content:
 */
@Data
@ApiModel(value = "emdgPriSalePriceRpcDTO ", description = "销售价格RPC出参")
public class EmdgPriSalePriceRpcDTO extends BaseViewModel implements Serializable {
    @Serial
    private static final long serialVersionUID = 656053671910776645L;


    @ApiModelProperty(value = "公司ID")
    private Long ouId;

    @ApiModelProperty(value = "销售组织ID")
    private Long buId;

    @ApiModelProperty("销售组织编码")
    private String deter1;
    @ApiModelProperty("销售组织名称")
    private String deter1Name;

    @ApiModelProperty("分销渠道")
    private String deter2;
    @ApiModelProperty("分销渠道名称")
    private String deter2Name;

    @ApiModelProperty("经销商编码")
    private String deter3;
    @ApiModelProperty("经销商名称")
    private String deter3Name;

    @ApiModelProperty("是否进行直减倒计时提醒")
    private String deter4;
    @ApiModelProperty("是否进行直减倒计时提醒")
    private String deter4Name;

    @ApiModelProperty("销售公司编码")
    private String deter5;
    @ApiModelProperty("销售公司名称")
    private String deter5Name;

    @ApiModelProperty("适用(经销商/门店)范围：全部或指定")
    @SysCode(sys = "yst-supp", mod = "APPLY_SCOPE_TYPE")
    private String deter6;
    @ApiModelProperty("适用(经销商/门店)范围：全部或指定名称")
    private String deter6Name;

    @ApiModelProperty("定价方式")
    @SysCode(sys = "yst-supp", mod = "PRICING_METHOD")
    private String deter7;
    @ApiModelProperty("定价方式名称")
    private String deter7Name;

    @ApiModelProperty("小数位设置")
    @SysCode(sys = "yst-supp", mod = "DECIMAL_PLACE_SET")
    private String deter8;
    @ApiModelProperty("小数位设置名称")
    private String deter8Name;

    @ApiModelProperty("门店编码")
    private String whLoc;
    @ApiModelProperty("门店名称")
    private String whLocName;

    @ApiModelProperty("货位")
    private String whPosi;

    @ApiModelProperty("批号")
    private String lotNo;

    @ApiModelProperty(value = "价格类型")
    @SysCode(sys = "yst-supp", mod = "SALE_PRICE_TYPE")
    private String priceType;
    @ApiModelProperty("价格类型名称")
    private String priceTypeName;

    @ApiModelProperty(value = "类型2(商品类型)")
    @SysCode(sys = "yst-supp", mod = "ITEM_TYPE2")
    private String priceType2;
    @ApiModelProperty("商品类型名称")
    private String priceType2Name;

    @ApiModelProperty(value = "价格类型3")
    private String priceType3;

    @ApiModelProperty(value = "商品SKU的ID")
    private Long itemId;

    @ApiModelProperty(value = "商品SKU编码")
    private String itemCode;

    @ApiModelProperty(value = "商品SKU名称")
    private String itemName;

    @ApiModelProperty(value = "商品名称2")
    private String itemName2;

    @ApiModelProperty(value = "商品规格型号")
    private String itemSpec;

    @ApiModelProperty(value = "SPU的ID")
    private Long spuId;

    @ApiModelProperty(value = "SPU编码")
    private String spuCode;

    @ApiModelProperty(value = "SPU名称")
    private String spuName;

    @ApiModelProperty(value = "商品来源组织编码")
    private String itemSourceOrg;
    @ApiModelProperty(value = "商品来源组织名称")
    private String itemSourceOrgName;

    @ApiModelProperty(value = "条码")
    private String barcode;

    @ApiModelProperty(value = "客户(经销商)ID")
    private Long custId;

    @ApiModelProperty("客户组(客户等级)")
    private String custGroup;

    @ApiModelProperty("销售区域(销售大区)")
    private String saleRegion;
    @ApiModelProperty("销售区域(销售大区)名称")
    private String saleRegionName;

    @ApiModelProperty("从数量(倒计时提醒天数)")
    private BigDecimal fromQty;

    @ApiModelProperty("到数量(倒计时提醒天数)")
    private BigDecimal toQty;

    @ApiModelProperty("含税价格(基地价格(元)/一口价(元)/最终成交价(元))")
    private BigDecimal price;

    @ApiModelProperty("不含税价格")
    private BigDecimal netPrice;

    @ApiModelProperty("价格1(下单直减(元)/基地直降参考价(元))")
    private BigDecimal price1;

    @ApiModelProperty("价格2(基地财务调整参考价(元))")
    private BigDecimal price2;

    @ApiModelProperty("价格3(基地选配差额参考价(元))")
    private BigDecimal price3;

    @ApiModelProperty("价格4(加价比例(%))")
    private BigDecimal price4;

    @ApiModelProperty("价格5(加价金额)")
    private BigDecimal price5;

    @ApiModelProperty("价格6(基地销售参考价(元))")
    private BigDecimal price6;

    @ApiModelProperty("价格7")
    private BigDecimal price7;

    @ApiModelProperty("价格8")
    private BigDecimal price8;

    @ApiModelProperty("价格9")
    private BigDecimal price9;

    @ApiModelProperty("价格10")
    private BigDecimal price10;

    @ApiModelProperty("币种")
    private String currCode;

    @ApiModelProperty("税率编号")
    private String taxRateNo;

    @ApiModelProperty("税率")
    private BigDecimal taxRate;

    @ApiModelProperty("单位(计量单位)")
    @SysCode(sys = "yst-supp", mod = "UOM")
    private String uom;
    @ApiModelProperty("计量单位")
    private String uomName;

    @ApiModelProperty("价格状态")
    @SysCode(sys = "yst-supp", mod = "SALE_PRICE_STATUS")
    private String priceStatus;
    @ApiModelProperty("价格状态")
    private String priceStatusName;

    @ApiModelProperty("价格来源")
    private String priceSource;

    @ApiModelProperty("来源单据类别")
    private String srcDocCls;

    @ApiModelProperty("来源单据ID")
    private Long srcDocId;

    @ApiModelProperty("来源单据明细ID")
    private Long srcDId;

    @ApiModelProperty(value = "生效时间(生效日期)")
    private LocalDateTime validFrom;

    @ApiModelProperty(value = "失效时间(失效日期)")
    private LocalDateTime validTo;

    @ApiModelProperty(value = "活动价生效日期")
    private LocalDateTime promDateF;

    @ApiModelProperty(value = "活动价失效日期")
    private LocalDateTime promDateT;

    @ApiModelProperty(value = "SAP最近更新日期")
    private LocalDateTime sapDate;

    @ApiModelProperty("活动含税价格")
    private BigDecimal promotionPrice;

    @ApiModelProperty("活动不含税价格")
    private BigDecimal promotionNetPrice;

    @ApiModelProperty(value = "商品分类码")
    private String itemCateCode;

    @ApiModelProperty(value = "商品分类")
    private String itemCatePath;
}
