package com.elitesland.yst.emdg.support.provider.item.dto;

import com.elitescloud.cloudt.common.annotation.SysCode;
import com.elitesland.yst.production.support.core.application.facade.item.vo.ItmItemCateSimpleTreeVO;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serial;
import java.io.Serializable;
import java.util.List;

/**
 * <p>
 * 功能说明:
 * </p>
 *
 * @Author Darren
 * @Date 2024/12/30
 * @Version 1.0
 * @Content:
 */
@Data
@ApiModel(value = "emdgItemRpcDTO ", description = "商品RPC出参")
public class EmdgItemRpcPageDTO implements Serializable {

    @Serial
    private static final long serialVersionUID = -5570724469732210953L;

    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("记录唯一ID")
    private Long spuId;

    @ApiModelProperty(value = "SPU编码")
    private String spuCode;

    @ApiModelProperty(value = "SPU名称")
    private String spuName;

    @ApiModelProperty(value = "规格型号")
    private String spec;

    @ApiModelProperty(value = "物料类型/商品分类 [UDC]ITM:ITEM_TYPE2")
    @SysCode(sys = "yst-supp", mod = "ITEM_TYPE2")
    private String itemType2;
    private String itemType2Name;

    @ApiModelProperty(value = "物料类型/车辆类型 [UDC]ITM:ITEM_TYPE5")
    @SysCode(sys = "yst-supp", mod = "ITEM_TYPE5")
    private String itemType5;
    @ApiModelProperty("物料类型名称")
    private String itemType5Name;

    @ApiModelProperty(value = "品类编号/二级品类")
    private String itemCateCode;
    @ApiModelProperty(value = "品类全路径")
    private List<ItmItemCateSimpleTreeVO> itemCatePath;
    @ApiModelProperty("品类(SPU)全称")
    private String itemCateFullName;

    @ApiModelProperty(value = "一级品系")
    private String itemCateCode2;
    @ApiModelProperty(value = "品类全路径")
    private List<ItmItemCateSimpleTreeVO> itemCate2Path;
    @ApiModelProperty("品类(SPU)全称")
    private String itemCate2FullName;

    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("品牌ID(仅用于前端渲染)")
    private Long brandId;

    @ApiModelProperty(value = "品牌编号")
    private String brand;

    @ApiModelProperty(value = "品牌名称")
    private String brandName;

    @ApiModelProperty(value = "销售组织ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long buId;

    @ApiModelProperty("销售组织")
    private String buCode;

    @ApiModelProperty(value = "销售组织名称")
    private String buName;

    @ApiModelProperty("销售工厂ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long manuerId;

    @ApiModelProperty("销售工厂")
    private String manuerCode;

    @ApiModelProperty("销售工厂名称")
    private String manuerName;

    @ApiModelProperty(value = "产地/原产国/交货工厂")
    @SysCode(sys = "yst-supp", mod = "ORIGIN")
    private String origin;
    private String originName;


    @ApiModelProperty(value = "发货模式/校验库存 [UDC]ITM:SHIPPING_METHOD")
    @SysCode(sys = "yst-supp", mod = "SHIPPING_METHOD")
    private String shippingMethod;
    @ApiModelProperty("发货模式")
    private String shippingMethodName;


    @ApiModelProperty("图片是否已维护")
    @SysCode(sys = "yst-supp", mod = "MAINTENANCE_TYPE")
    private String es6;
    @ApiModelProperty("图片是否已维护名称")
    private String es6Name;

    @ApiModelProperty("SPU维度的商城上架状态")
    @SysCode(sys = "yst-supp", mod = "UP_DOWN_STATUS")
    private String es8;
    @ApiModelProperty("SPU维度的商城上架状态")
    private String es8Name;

    @ApiModelProperty(value = "SPU商品状态")
    @SysCode(sys = "yst-supp", mod = "ITEM_STATUS")
    private String es9;
    private String es9Name;

    @ApiModelProperty("视频是否已维护")
    @SysCode(sys = "yst-supp", mod = "MAINTENANCE_TYPE")
    private String es10;
    @ApiModelProperty("视频是否已维护名称")
    private String es10Name;

    @ApiModelProperty("分销渠道")
    @SysCode(sys = "yst-supp", mod = "SALE_CHANNEL")
    private String cat4;
    @ApiModelProperty("分销渠道名称")
    private String cat4Name;

    /******经销商授权范围维度字段***/
    @ApiModelProperty("商品描述")
    private String es3;
    /******经销商授权范围维度字段***/
}
