package com.elitesland.yst.emdg.support.provider.item.service;

import com.elitesland.yst.emdg.support.Application;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

@FeignClient(name = Application.NAME, path = Application.PATH + LmItemBomRpcService.PATH)
public interface LmItemBomRpcService {

    String PATH = "/lm/itm/itemBom/rpc";

    /**
     * 查询配件的子配件
     *
     * @param parentCodes
     * @return 子件商品id集合
     */
    @PostMapping("/findByItemCode")
    List<Long> queryChildItem(@RequestBody List<String> parentCodes);

    /**
     * 查询车型对应整车的子配件
     * @param itemType5
     * @return 子件商品id集合
     */
    @GetMapping("/findByItemType5")
    List<Long> queryChildItem(@RequestParam("itemType5") String itemType5);
    /**
     * 查询配件适配车型
     * @param itemIds
     * @return 商品id集合
     */
    @PostMapping("/findByItemIds")
    List<String> queryVehicle(@RequestBody List<Long> itemIds);
}
