package com.elitesland.yst.emdg.support.provider.item.param;

import com.elitescloud.boot.common.param.AbstractOrderQueryParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;


@EqualsAndHashCode(callSuper = true)
@Data
@ApiModel("商品品类属性查询参数")
public class ItmCatePropSearchParam extends AbstractOrderQueryParam {

    private static final long serialVersionUID = -7475069702207320878L;

    /**
     * Id
     */
    @ApiModelProperty(value = "Id")
    private Long id;

    /**
     * 品类编码
     */
    @ApiModelProperty(value = "品类编码")
    private String itemCateCode;

    /**
     * 属性名称/编码，支持模糊查询
     */
    @ApiModelProperty(value = "属性名称/编码，支持模糊查询")
    private String propCodeName;

    /**
     * 属性类型 [UDC]ITM:CATE_PROP_TYPE
     */
    @ApiModelProperty(value = "属性类型 [UDC]ITM:CATE_PROP_TYPE")
    private String catePropType;

    /**
     * 单选复选(0:单选,1:复选)
     */
    @ApiModelProperty(value = "单选复选(0:单选,1:复选)")
    private Integer isBox;

    /**
     * 录入方式(0:列表选择,1:手动输入)
     */
    @ApiModelProperty(value = "录入方式(0:列表选择,1:手动输入)")
    private Integer isHand;

    /**
     * 是否必填(0:否,1:是)
     */
    @ApiModelProperty(value = "是否必填(0:否,1:是)")
    private Integer isMust;

    @ApiModelProperty(value = "自定义属性(0:否,1:是)")
    private Integer isCust;


    @ApiModelProperty(value = "用于检索(0:否,1:是)")
    private Integer isSearch;

    /**
     * 是否和SKU相关(0:否,1:是)
     */
    @ApiModelProperty(value = "是否和SKU相关(0:否,1:是)")
    private Integer isSku;

    /**
     * 排序
     */
    @ApiModelProperty(value = "排序")
    private Integer sortNo;



    /**
     *  选择 id列表
     */
    @ApiModelProperty(value = "选择 id列表")
    private List<Long> ids;
}
